<?php
function sv_wc_memberships_allow_acf_meta_box_ids($allowed_meta_box_ids)
{

    if (function_exists('acf_get_field_groups')) {

        $field_groups = array_merge(
            acf_get_field_groups(array('post_type' => 'wc_membership_plan')),
            acf_get_field_groups(array('post_type' => 'wc_user_membership'))
        );

        foreach ($field_groups as $field_group) {
            $allowed_meta_box_ids[] = 'acf-' . $field_group['key'];
        }
    }

    return $allowed_meta_box_ids;
}

add_filter('wc_memberships_allowed_meta_box_ids', 'sv_wc_memberships_allow_acf_meta_box_ids');
add_action('wc_memberships_user_membership_saved', 'poker_membership_card_generated', 10, 2);

if (!function_exists('poker_membership_card_generated')) {
    function poker_membership_card_generated($membership_plan, $args)
    {
		$cardId='';
	  if(!empty($membership_plan)){ $user_membership_id = $args['user_membership_plan'];}
		else{ $user_membership_id = $args['user_membership_id'];} 
      

        $membership = wc_memberships_get_user_membership($user_membership_id);
       
        require_once 'vCard.php';
        $vcard = new vCard;
        $vcard->setName(poker_get_user_full_name(get_user_by('id', $args['user_id'])), '');


        $vcard->setTitle($membership_plan->name . " Card");
       
		$membership_end_date = '';
	 if(!empty($membership_plan)){ 

		if ($membership_plan->get_access_length_amount()) {
            if ($args['is_update']) {
                $now = get_post_meta($user_membership_id, '_end_date', true);
				     
            } else {
                $now = current_time('mysql', true);

            }
            $membership_end_date = $membership_plan->get_expiration_date($now, $args);
            $membership_end_date = date('m-d-Y H:i:s', strtotime($membership_end_date));

			
        }
}
 else {
	               $now = current_time('mysql', true);
            $membership_end_date = date('m-d-Y H:i:s', strtotime($now));
}
	
		
        $note = "Date end: " . $membership_end_date . "\nCard id: $membership->id";

    $playerId=$args['user_id'];
if(strlen($membership_end_date)<2){$endDate='Never';}else{$endDate=$membership_end_date;}
     
	    $anyDB = poker_Connector::connector()->connectToDatabase();
		global $wpdb;
	    $is_registered = $wpdb->get_results("SELECT wp_user_id,player_id from poker_player where wp_user_id='$playerId' " );
        if(sizeof($is_registered)<1){
        $generated_player_id=rand(30612,90612);
		$checkID = $anyDB->get_results("SELECT playerid from ui_profiles where playerid='$generated_player_id' " );
		$success=false;
			
		while(!$success){
				if(sizeof($checkID) <1)
		{
			$wpdb->insert('poker_player', array(
    'wp_user_id' => $playerId,
    'player_id' => $generated_player_id,
		 'player_rank'=>'0',
		 'website'=>'NULL'
       ));
			$note = "Date end: " . $endDate . "\nCard id: $generated_player_id";
			$vcard->setNote($note);
			$success=true;
					$cardId=$generated_player_id;
		}
        else {
			
		}
		}
		}
		else {
			$id=$is_registered[0]->player_id;
			$note = "Date end: " . $endDate . "\nCard id: $id";
			$vcard->setNote($note);
			$cardId=$id;
		}
		
        //image qr code
        $attach_id = poker_generate_membership_qr_code($vcard, $args['user_id']);

		$x= update_field('qrcode_image', $attach_id, $args['user_membership_id']);
   	  //  echo var_dump($attach_id);
		//exit();
        //sending email with card
        $user = get_user_by('id', $args['user_id']);
        $subject = "Membership Card Status Changed";
        ob_start();
		  $attachments = realpath(get_attached_file($attach_id, true));
								 // echo var_dump($attach_id);
 
        get_template_part('woocommerce/emails/membership', 'activated', [
            'plan_name' => $membership_plan->name,
            'email_heading' => $subject,
			'cardId'=>$cardId
			
		
        ]);
        $html = ob_get_clean();
		
		 ob_start();
		  $attachments = realpath(get_attached_file($attach_id, true));
								 // echo var_dump($attach_id);
 
        get_template_part('woocommerce/emails/membership', 'admin', [
            'plan_name' => $membership_plan->name,
            'email_heading' => $subject,
			'user' =>$user,
			'cardId'=>$cardId
		
        ]);
		$admin_html =ob_get_clean(); 
        $headers = array(
            'content-type: text/html',
        );
		
		
		
       if(strlen($membership_plan->name ) !=0)
	   {
		 wp_mail($user->user_email, $subject, $html, $headers, $attachments);  
		 wp_mail('mpk8807@gmail.com', $subject, $admin_html, $headers, $attachments); 
		
	   }
       
      
    }
}


if (!function_exists('poker_generate_membership_qr_code')) {
    function poker_generate_membership_qr_code($generated_data, $user_id, $size = '400x400')
    {
        require_once ABSPATH . 'wp-admin/includes/file.php';
		require_once( ABSPATH . 'wp-admin/includes/media.php' );

        $logo = poker_theme_asset('img/logo.png');

        $QR = imagecreatefrompng('https://chart.googleapis.com/chart?cht=qr&chld=H|1&chs=' . $size . '&chl=' . urlencode($generated_data));
        if ($logo !== FALSE) {
            $logo = imagecreatefromstring(file_get_contents($logo));

            $QR_width = imagesx($QR);
            $QR_height = imagesy($QR);

            $logo_width = imagesx($logo);
            $logo_height = imagesy($logo);

            // Scale logo to fit in the QR Code
            $logo_qr_width = $QR_width / 3;
            $scale = $logo_width / $logo_qr_width;
            $logo_qr_height = $logo_height / $scale;

            imagecopyresampled($QR, $logo, $QR_width / 3, $QR_height / 3, 0, 0, $logo_qr_width, $logo_qr_height, $logo_width, $logo_height);
        }
        
        $image_file_path = wp_upload_dir()['basedir'] . "/" . uniqid($user_id . time(), true) . ".png";

    $x=    imagepng($QR, $image_file_path);
        imagedestroy($QR);

        $file_path = $image_file_path;
        $file_name = basename($file_path);
        $file_type = wp_check_filetype($file_name, null);
        $attachment_title = sanitize_file_name(pathinfo($file_name, PATHINFO_FILENAME));
        $wp_upload_dir = wp_upload_dir();

        $post_info = array(
            'guid'           => $wp_upload_dir['url'] . '/' . $file_name,
          // 'guid'=> '/home/devanytwocards/public_html/wp-content/uploads/'."'.$file_name.'",
            'post_mime_type' => $file_type['type'],
            'post_title'     => $attachment_title,
            'post_content'   => '',
            'post_status'    => 'inherit',
        );
//$upload_overrides = array( 'test_form' => false );

//$movefile = wp_handle_upload( $x, $upload_overrides );
        // Create the attachment
    $attach_id = wp_insert_attachment($post_info, $image_file_path, null);


        // Include image.php
        require_once(ABSPATH . 'wp-admin/includes/image.php');
		
		


        // Define attachment metadata
   $attach_data = wp_generate_attachment_metadata($attach_id, $file_path);

        // Assign metadata to attachment
   $b= wp_update_attachment_metadata($attach_id,  $attach_data);
       // media_handle_upload( $attach_id, 0 );
       
  return $attach_id;
	
	}
}
